# =図鑑ベーススクリプト
#
# 図鑑に関する基本的な機能をまとめたスクリプトです。
#
#
# ==更新履歴
#   Date     Version Author Comment
# ==15/09/03 2.0.2   トリス 統合J～U N T
# ==17/09/21 2.2.0   ひまわり　統合3

#==============================================================================
# ■ NWConst::LibraryManager
#----------------------------------------------------------------------------
# 図鑑のフラグデータを取得、操作するメソッドの集合です。
# 機能が必要なオブジェクトにmixinして使用します。
#==============================================================================
module NWConst::LibraryManager
  #--------------------------------------------------------------------------
  # ● 図鑑が使用可能か？(一つでも図鑑がアンロックされているか？)
  #--------------------------------------------------------------------------
  def lib_usable?
    lib_actor_unlocked? || lib_enemy_unlocked? || lib_weapon_unlocked? || lib_armor_unlocked? || lib_accessory_unlocked? || lib_item_unlocked? || lib_medal_unlocked? || lib_stone_unlocked?
  end

  #--------------------------------------------------------------------------
  # ● アクター図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_actor_unlocked?
    $game_library.lib_actor_unlocked?
  end

  #--------------------------------------------------------------------------
  # ● エネミー図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_enemy_unlocked?
    $game_library.lib_enemy_unlocked?
  end

  #--------------------------------------------------------------------------
  # ● ウェポン図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_weapon_unlocked?
    $game_library.lib_weapon_unlocked?
  end

  #--------------------------------------------------------------------------
  # ● アーマー図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_armor_unlocked?
    $game_library.lib_armor_unlocked?
  end

  #--------------------------------------------------------------------------
  # ● アクセサリ図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_accessory_unlocked?
    $game_library.lib_accessory_unlocked?
  end

  #--------------------------------------------------------------------------
  # ● アイテム図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_item_unlocked?
    $game_library.lib_item_unlocked?
  end

  #--------------------------------------------------------------------------
  # ● 取得実績がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_medal_unlocked?
    $game_library.lib_medal_unlocked?
  end

  def lib_stone_unlocked?
    $game_library.lib_stone_unlocked?
  end

  #--------------------------------------------------------------------------
  # ● アクター図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_actor
    $game_library.unlock_lib_actor
  end

  #--------------------------------------------------------------------------
  # ● エネミー図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_enemy
    $game_library.unlock_lib_enemy
  end

  #--------------------------------------------------------------------------
  # ● ウェポン図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_weapon
    $game_library.unlock_lib_weapon
  end

  #--------------------------------------------------------------------------
  # ● アーマー図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_armor
    $game_library.unlock_lib_armor
  end

  #--------------------------------------------------------------------------
  # ● アクセサリ図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_accessory
    $game_library.unlock_lib_accessory
  end

  #--------------------------------------------------------------------------
  # ● アイテム図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_item
    $game_library.unlock_lib_item
  end

  #--------------------------------------------------------------------------
  # ● 取得実績アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_medal
    $game_library.unlock_lib_medal
  end

  def unlock_lib_stone
    $game_library.unlock_lib_stone
  end

  #--------------------------------------------------------------------------
  # ● アクター図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_actor
    $game_library.lock_lib_actor
  end

  #--------------------------------------------------------------------------
  # ● エネミー図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_enemy
    $game_library.lock_lib_enemy
  end

  #--------------------------------------------------------------------------
  # ● ウェポン図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_weapon
    $game_library.lock_lib_weapon
  end

  #--------------------------------------------------------------------------
  # ● アーマー図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_armor
    $game_library.lock_lib_armor
  end

  #--------------------------------------------------------------------------
  # ● アクセサリ図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_accessory
    $game_library.lock_lib_accessory
  end

  #--------------------------------------------------------------------------
  # ● アイテム図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_item
    $game_library.lock_lib_item
  end

  #--------------------------------------------------------------------------
  # ● 取得実績ロック
  #--------------------------------------------------------------------------
  def lock_lib_medal
    $game_library.lock_lib_medal
  end

  def lock_lib_stone
    $game_library.lock_lib_stone
  end

  #--------------------------------------------------------------------------
  # ● アクターが敵撃破した回数取得
  #--------------------------------------------------------------------------
  def actor_defeat(id)
    $game_library.actor_defeat(id)
  end

  #--------------------------------------------------------------------------
  # ● アクターがイカせた回数取得
  #--------------------------------------------------------------------------
  def actor_carry(id)
    $game_library.actor_carry(id)
  end

  #--------------------------------------------------------------------------
  # ● アクターがイかされた回数取得
  #--------------------------------------------------------------------------
  def actor_orgasm(id)
    $game_library.actor_orgasm(id)
  end

  #--------------------------------------------------------------------------
  # ● アクターが戦闘不能になった回数取得
  #--------------------------------------------------------------------------
  def actor_down(id)
    $game_library.actor_down(id)
  end

  #--------------------------------------------------------------------------
  # ● エネミーが撃破された回数取得
  #--------------------------------------------------------------------------
  def enemy_down(id)
    $game_library.enemy_down(id)
  end

  #--------------------------------------------------------------------------
  # ● エネミーが勝利した回数取得
  #--------------------------------------------------------------------------
  def enemy_victory(id)
    $game_library.enemy_victory(id)
  end

  #--------------------------------------------------------------------------
  # ● エネミーがイかされた回数取得
  #--------------------------------------------------------------------------
  def enemy_orgasm(id)
    $game_library.enemy_orgasm(id)
  end

  #--------------------------------------------------------------------------
  # ● パーティの戦闘回数取得
  #--------------------------------------------------------------------------
  def party_battle
    $game_library.party_battle
  end

  #--------------------------------------------------------------------------
  # ● パーティの逃亡回数を取得
  #--------------------------------------------------------------------------
  def party_escape
    $game_library.party_escape
  end

  #--------------------------------------------------------------------------
  # ● パーティの敗北回数を取得
  #--------------------------------------------------------------------------
  def party_lose
    $game_library.party_lose
  end

  #--------------------------------------------------------------------------
  # ● パーティの総撃破数を取得
  #--------------------------------------------------------------------------
  def party_defeat
    $game_library.party_defeat
  end

  #--------------------------------------------------------------------------
  # ● パーティの倒された総数を取得
  #--------------------------------------------------------------------------
  def party_down
    $game_library.party_down
  end

  #--------------------------------------------------------------------------
  # ● パーティのイかされた総数を取得
  #--------------------------------------------------------------------------
  def party_orgasm
    $game_library.party_orgasm
  end

  #--------------------------------------------------------------------------
  # ● パーティの味方総数を取得
  #--------------------------------------------------------------------------
  def party_friendly
    $game_party.include_members.reject { |actor| actor.luca? }.size
  end

  #--------------------------------------------------------------------------
  # ● アクターが倒された数を取得
  #--------------------------------------------------------------------------
  def actor_down(id)
    $game_library.actor_down(id)
  end

  #--------------------------------------------------------------------------
  # ● アクターがイかされた数を取得
  #--------------------------------------------------------------------------
  def actor_orgasm(id)
    $game_library.actor_orgasm(id)
  end

  #--------------------------------------------------------------------------
  # ● ルカが仲間にイかされた数を取得
  #--------------------------------------------------------------------------
  def friendly_orgasm
    $game_library.friendly_orgasm
  end

  #--------------------------------------------------------------------------
  # ● バトルファック勝利数を取得
  #--------------------------------------------------------------------------
  def battlefuck_win
    $game_library.battlefuck_win
  end

  #--------------------------------------------------------------------------
  # ● バトルファック敗北数を取得
  #--------------------------------------------------------------------------
  def battlefuck_lose
    $game_library.battlefuck_lose
  end

  #--------------------------------------------------------------------------
  # ● 購入累計金額を取得
  #--------------------------------------------------------------------------
  def purchase_gold
    $game_library.purchase_gold
  end

  #--------------------------------------------------------------------------
  # ● 合成回数を取得
  #--------------------------------------------------------------------------
  def party_synthesize
    $game_library.party_synthesize
  end

  #--------------------------------------------------------------------------
  # ● 転職回数を取得
  #--------------------------------------------------------------------------
  def party_class_change
    $game_library.party_class_change
  end

  #--------------------------------------------------------------------------
  # ● 転種回数を取得
  #--------------------------------------------------------------------------
  def party_tribe_change
    $game_library.party_tribe_change
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター発見フラグ照会
  #--------------------------------------------------------------------------
  def actor_discovery?(id)
    $game_library.actor.discovery?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー発見フラグ照会
  #--------------------------------------------------------------------------
  def enemy_discovery?(id)
    $game_library.enemy.discovery?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器発見フラグ照会
  #--------------------------------------------------------------------------
  def weapon_discovery?(id)
    $game_library.weapon.discovery?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具発見フラグ照会
  #--------------------------------------------------------------------------
  def armor_discovery?(id)
    $game_library.armor.discovery?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ発見フラグ照会
  #--------------------------------------------------------------------------
  def accessory_discovery?(id)
    $game_library.accessory.discovery?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム発見フラグ照会
  #--------------------------------------------------------------------------
  def item_discovery?(id)
    $game_library.item.discovery?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター所有フラグ照会
  #--------------------------------------------------------------------------
  def actor_had?(id)
    $game_library.actor.had?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー所有フラグ照会
  #--------------------------------------------------------------------------
  def enemy_had?(id)
    $game_library.enemy.had?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器所有フラグ照会
  #--------------------------------------------------------------------------
  def weapon_had?(id)
    $game_library.weapon.had?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具所有フラグ照会
  #--------------------------------------------------------------------------
  def armor_had?(id)
    $game_library.armor.had?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ所有フラグ照会
  #--------------------------------------------------------------------------
  def accessory_had?(id)
    $game_library.accessory.had?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム所有フラグ照会
  #--------------------------------------------------------------------------
  def item_had?(id)
    $game_library.item.had?(id)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター発見フラグ開示
  #--------------------------------------------------------------------------
  def set_actor_discovery(*args)
    $game_library.actor.set_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー発見フラグ開示
  #--------------------------------------------------------------------------
  def set_enemy_discovery(*args)
    $game_library.enemy.set_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器発見フラグ開示
  #--------------------------------------------------------------------------
  def set_weapon_discovery(*args)
    $game_library.weapon.set_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具発見フラグ開示
  #--------------------------------------------------------------------------
  def set_armor_discovery(*args)
    $game_library.armor.set_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ発見フラグ開示
  #--------------------------------------------------------------------------
  def set_accessory_discovery(*args)
    $game_library.accessory.set_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム発見フラグ開示
  #--------------------------------------------------------------------------
  def set_item_discovery(*args)
    $game_library.item.set_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター所有フラグ開示
  #--------------------------------------------------------------------------
  def set_actor_had(*args)
    $game_library.unlock_lib_actor unless $game_library.lib_actor_unlocked?
    $game_library.actor.set_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー所有フラグ開示
  #--------------------------------------------------------------------------
  def set_enemy_had(*args)
    $game_library.unlock_lib_enemy unless $game_library.lib_enemy_unlocked?
    $game_library.enemy.set_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器所有フラグ開示
  #--------------------------------------------------------------------------
  def set_weapon_had(*args)
    $game_library.unlock_lib_weapon unless $game_library.lib_weapon_unlocked?
    $game_library.weapon.set_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具所有フラグ開示
  #--------------------------------------------------------------------------
  def set_armor_had(*args)
    $game_library.unlock_lib_armor unless $game_library.lib_armor_unlocked?
    $game_library.armor.set_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ所有フラグ開示
  #--------------------------------------------------------------------------
  def set_accessory_had(*args)
    $game_library.unlock_lib_accessory unless $game_library.lib_accessory_unlocked?
    $game_library.accessory.set_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム所有フラグ開示
  #--------------------------------------------------------------------------
  def set_item_had(*args)
    $game_library.unlock_lib_item unless $game_library.lib_item_unlocked?
    $game_library.item.set_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター発見フラグ消去
  #--------------------------------------------------------------------------
  def clear_actor_discovery(*args)
    $game_library.actor.clear_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー発見フラグ消去
  #--------------------------------------------------------------------------
  def clear_enemy_discovery(*args)
    $game_library.enemy.clear_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器発見フラグ消去
  #--------------------------------------------------------------------------
  def clear_weapon_discovery(*args)
    $game_library.weapon.clear_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具発見フラグ消去
  #--------------------------------------------------------------------------
  def clear_armor_discovery(*args)
    $game_library.armor.clear_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ発見フラグ消去
  #--------------------------------------------------------------------------
  def clear_accessory_discovery(*args)
    $game_library.accessory.clear_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム発見フラグ消去
  #--------------------------------------------------------------------------
  def clear_item_discovery(*args)
    $game_library.item.clear_discovery(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター所有フラグ消去
  #--------------------------------------------------------------------------
  def clear_actor_had(*args)
    $game_library.actor.clear_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー所有フラグ消去
  #--------------------------------------------------------------------------
  def clear_enemy_had(*args)
    $game_library.enemy.clear_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器所有フラグ消去
  #--------------------------------------------------------------------------
  def clear_weapon_had(*args)
    $game_library.weapon.clear_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具所有フラグ消去
  #--------------------------------------------------------------------------
  def clear_armor_had(*args)
    $game_library.armor.clear_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ所有フラグ消去
  #--------------------------------------------------------------------------
  def clear_accessory_had(*args)
    $game_library.accessory.clear_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム所有フラグ消去
  #--------------------------------------------------------------------------
  def clear_item_had(*args)
    $game_library.item.clear_had(args)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター発見フラグ全開示
  #--------------------------------------------------------------------------
  def all_actor_discovery
    $game_library.actor.set_discovery(get_valid_actors)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー発見フラグ全開示
  #--------------------------------------------------------------------------
  def all_enemy_discovery
    $game_library.enemy.set_discovery(get_valid_enemies)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器発見フラグ全開示
  #--------------------------------------------------------------------------
  def all_weapon_discovery
    $game_library.weapon.set_discovery(get_valid_weapons)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具発見フラグ全開示
  #--------------------------------------------------------------------------
  def all_armor_discovery
    $game_library.armor.set_discovery(get_valid_armors)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ発見フラグ全開示
  #--------------------------------------------------------------------------
  def all_accessory_discovery
    $game_library.accessory.set_discovery(get_valid_accessories)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム発見フラグ全開示
  #--------------------------------------------------------------------------
  def all_item_discovery
    $game_library.item.set_discovery(get_valid_items)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター所有フラグ全開示
  #--------------------------------------------------------------------------
  def all_actor_had
    $game_library.actor.set_had(get_valid_actors)
    $game_library.unlock_lib_actor
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー所有フラグ全開示
  #--------------------------------------------------------------------------
  def all_enemy_had
    $game_library.enemy.set_had(get_valid_enemies)
    $game_library.unlock_lib_enemy
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器所有フラグ全開示
  #--------------------------------------------------------------------------
  def all_weapon_had
    $game_library.weapon.set_had(get_valid_weapons)
    $game_library.unlock_lib_weapon
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具所有フラグ全開示
  #--------------------------------------------------------------------------
  def all_armor_had
    $game_library.armor.set_had(get_valid_armors)
    $game_library.unlock_lib_armor
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ所有フラグ全開示
  #--------------------------------------------------------------------------
  def all_accessory_had
    $game_library.accessory.set_had(get_valid_accessories)
    $game_library.unlock_lib_accessory
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム所有フラグ全開示
  #--------------------------------------------------------------------------
  def all_item_had
    $game_library.item.set_had(get_valid_items)
    $game_library.unlock_lib_item
  end

  def all_stone_had
    $game_library.item.set_had(get_valid_stones)
    $game_library.unlock_lib_stone
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター発見フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_actor_discovery
    $game_library.actor.clear_discovery(get_valid_actors)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー発見フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_enemy_discovery
    $game_library.enemy.clear_discovery(get_valid_enemies)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器発見フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_weapon_discovery
    $game_library.weapon.clear_discovery(get_valid_weapons)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具発見フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_armor_discovery
    $game_library.armor.clear_discovery(get_valid_armors)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ発見フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_accessory_discovery
    $game_library.accessory.clear_discovery(get_valid_accessories)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム発見フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_item_discovery
    $game_library.item.clear_discovery(get_valid_items)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクター所有フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_actor_had
    $game_library.actor.clear_had(get_valid_actors)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑エネミー所有フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_enemy_had
    $game_library.enemy.clear_had(get_valid_enemies)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑武器所有フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_weapon_had
    $game_library.weapon.clear_had(get_valid_weapons)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑防具所有フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_armor_had
    $game_library.armor.clear_had(get_valid_armors)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アクセサリ所有フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_accessory_had
    $game_library.accessory.clear_had(get_valid_accessories)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑アイテム所有フラグ全消去
  #--------------------------------------------------------------------------
  def all_clear_item_had
    $game_library.item.clear_had(get_valid_items)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑全開示
  #--------------------------------------------------------------------------
  def library_all_open
    p "テスト用：図鑑全開示"
    all_actor_had
    all_enemy_had
    all_weapon_had
    all_armor_had
    all_accessory_had
    all_item_had
  end

  #--------------------------------------------------------------------------
  # ● 図鑑全消去
  #--------------------------------------------------------------------------
  def library_all_close
    all_clear_actor_discovery
    all_clear_enemy_discovery
    all_clear_weapon_discovery
    all_clear_armor_discovery
    all_clear_accessory_discovery
    all_clear_item_discovery
  end

  #--------------------------------------------------------------------------
  # ● 図鑑のアクター項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_actor
    Integer($data_library.collect_per_actor * 100)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑のエネミー項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_enemy
    Integer($data_library.collect_per_enemy * 100)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑の武器項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_weapon
    Integer($data_library.collect_per_weapon * 100)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑の防具項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_armor
    Integer($data_library.collect_per_armor * 100)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑のアクセサリ項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_accessory
    Integer($data_library.collect_per_accessory * 100)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑のアイテム項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_item
    Integer($data_library.collect_per_item * 100)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑の実績項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_medal
    Integer($data_library.collect_per_medal * 100)
  end

  def collect_per_stone
    Integer($data_library.collect_per_stone * 100)
  end

  #--------------------------------------------------------------------------
  # ● 図鑑の全項目合計の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_all
    Integer($data_library.collect_per_all * 100)
  end

  #--------------------------------------------------------------------------
  # ● 有効なアクターIDを全取得
  #--------------------------------------------------------------------------
  def get_valid_actors
    $data_actors.select { |item| !item.nil? && !item.name.empty? && !item.lib_exclude? }.collect { |item| item.id }
  end

  #--------------------------------------------------------------------------
  # ● 有効なエネミーIDを全取得
  #--------------------------------------------------------------------------
  def get_valid_enemies
    $data_enemies.select { |item| !item.nil? && !item.name.empty? && !item.lib_exclude? }.collect { |item| item.id }
  end

  #--------------------------------------------------------------------------
  # ● 有効なウェポンIDを全取得
  #--------------------------------------------------------------------------
  def get_valid_weapons
    $data_weapons.select { |item| !item.nil? && !item.name.empty? && !item.lib_exclude? }.collect { |item| item.id }
  end

  #--------------------------------------------------------------------------
  # ● 有効なアーマーIDを全取得
  #--------------------------------------------------------------------------
  def get_valid_armors
    $data_armors.select do |item|
      !item.nil? && !item.name.empty? && !item.lib_exclude? && !item.is_accessory?
    end.collect { |item| item.id }
  end

  #--------------------------------------------------------------------------
  # ● 有効なアクセサリIDを全取得
  #--------------------------------------------------------------------------
  def get_valid_accessories
    $data_armors.select do |item|
      !item.nil? && !item.name.empty? && !item.lib_exclude? && item.is_accessory?
    end.collect { |item| item.id }
  end

  #--------------------------------------------------------------------------
  # ● 有効なアイテムIDを全取得
  #--------------------------------------------------------------------------
  def get_valid_items
    $data_items.select { |item| !item.nil? && !item.name.empty? && !item.lib_exclude? }.collect { |item| item.id }
  end

  #--------------------------------------------------------------------------
  # ● 有効な職業IDを全取得
  #--------------------------------------------------------------------------
  def get_valid_jobs
    $data_classes.select do |item|
      !item.nil? && !item.name.empty? && !item.lib_exclude? && item.job?
    end.collect { |item| item.id }
  end

  #--------------------------------------------------------------------------
  # ● 有効な種族IDを全取得
  #--------------------------------------------------------------------------
  def get_valid_tribes
    $data_classes.select do |item|
      !item.nil? && !item.name.empty? && !item.lib_exclude? && item.tribe?
    end.collect { |item| item.id }
  end

  #--------------------------------------------------------------------------
  # ● 有効なメダルIDを全取得
  #--------------------------------------------------------------------------
  def get_valid_medals
    NWConst::Library::MEDAL_DATA.keys.select do |id|
      !NWConst::Library::NO_USE_MEDAL.include?(id)
    end
  end

  #--------------------------------------------------------------------------
  # ● 実績取得
  #--------------------------------------------------------------------------
  def gain_medal(id)
    $game_library.gain_medal(id)
  end

  #--------------------------------------------------------------------------
  # ● 実績取得済み？
  #--------------------------------------------------------------------------
  def has_medal?(id)
    $game_library.has_medal?(id)
  end

  #--------------------------------------------------------------------------
  # ● 実績アイコンID取得
  #--------------------------------------------------------------------------
  def medal_icon_id(id)
    $game_library.medal_icon_id(id)
  end

  #--------------------------------------------------------------------------
  # ● 実績タイトル取得
  #--------------------------------------------------------------------------
  def medal_title(id)
    $game_library.medal_title(id)
  end

  #--------------------------------------------------------------------------
  # ● 実績説明取得
  #--------------------------------------------------------------------------
  def medal_description(id)
    $game_library.medal_description(id)
  end

  #--------------------------------------------------------------------------
  # ● 実績優先順位取得
  #--------------------------------------------------------------------------
  def medal_priority(id)
    $game_library.medal_priority(id)
  end

  #--------------------------------------------------------------------------
  # ● 実績取得時間取得
  #--------------------------------------------------------------------------
  def medal_gain_time(id)
    $game_library.medal_gain_time(id)
  end
end

#==============================================================================
# ■ Flag_Library
#----------------------------------------------------------------------------
# 図鑑に関するデータを保存するデータ構造のクラスです。
# 配列のひとつの要素には30bitのフラグを格納することにします。
# IDをキーに値は&1=発見済み, &2=所有済みです。
# ひとつの項目に2bit使うので、配列の要素毎に15項目ずつフラグが格納されます。
#==============================================================================
class Flag_Library
  #--------------------------------------------------------------------------
  # ● 定数
  #--------------------------------------------------------------------------
  BIT   = 2
  LIMIT = 15
  #--------------------------------------------------------------------------
  # ● 公開インスタンス変数
  #--------------------------------------------------------------------------
  attr_reader :data

  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize
    @data = []
  end

  #--------------------------------------------------------------------------
  # ● 代入先データ位置変換
  #--------------------------------------------------------------------------
  def trans_base(id)
    @data[id / LIMIT] ||= 0
  end

  #--------------------------------------------------------------------------
  # ● 代入データ位置変換
  #--------------------------------------------------------------------------
  def trans_flag(id, flag)
    flag << BIT * (id % LIMIT)
  end

  #--------------------------------------------------------------------------
  # ● フラグセット
  #--------------------------------------------------------------------------
  def set_flag(id, flag)
    @data[id / LIMIT] ||= 0
    @data[id / LIMIT] |= trans_flag(id, flag)
  end

  #--------------------------------------------------------------------------
  # ● フラグクリア
  #--------------------------------------------------------------------------
  def clear_flag(id, flag)
    @data[id / LIMIT] ||= 0
    @data[id / LIMIT] &= ~trans_flag(id, flag)
  end

  #--------------------------------------------------------------------------
  # ● 発見済みの項目か？
  #--------------------------------------------------------------------------
  def discovery?(id)
    trans_base(id) & trans_flag(id, 0b01) > 0
  end

  #--------------------------------------------------------------------------
  # ● 所有済みの項目か？
  #--------------------------------------------------------------------------
  def had?(id)
    trans_base(id) & trans_flag(id, 0b10) > 0
  end

  #--------------------------------------------------------------------------
  # ● 発見済みの設定
  #--------------------------------------------------------------------------
  def set_discovery(*args)
    args.flatten.each do |id|
      next unless id.is_a?(Integer)
      next if id < 0

      set_flag(id, 0b01)
    end
  end

  #--------------------------------------------------------------------------
  # ● 所有済みの設定 (発見済みフラグも同時に立てる)
  #--------------------------------------------------------------------------
  def set_had(*args)
    args.flatten.each do |id|
      next unless id.is_a?(Integer)
      next if id < 0

      set_flag(id, 0b11)
    end
  end

  #--------------------------------------------------------------------------
  # ● 発見済みのクリア (所有済みフラグも同時に削除)
  #--------------------------------------------------------------------------
  def clear_discovery(*args)
    args.flatten.each do |id|
      next unless id.is_a?(Integer)
      next if id < 0

      clear_flag(id, 0b11)
    end
  end

  #--------------------------------------------------------------------------
  # ● 所有済みのクリア (所有済みフラグのみ削除)
  #--------------------------------------------------------------------------
  def clear_had(*args)
    args.flatten.each do |id|
      next unless id.is_a?(Integer)
      next if id < 0

      clear_flag(id, 0b10)
    end
  end
end

#==============================================================================
# ■ Data_Library
#----------------------------------------------------------------------------
# 図鑑に表示するデータを管理します。
# このクラスのオブジェクトは開始時に生成され、
# $game_libraryでアクセスができます。
#==============================================================================
class Data_Library
  #--------------------------------------------------------------------------
  # ● Mix-in
  #--------------------------------------------------------------------------
  include NWConst::LibraryManager
  #--------------------------------------------------------------------------
  # ● 公開インスタンス変数
  #--------------------------------------------------------------------------
  attr_reader :actor
  attr_reader :enemy
  attr_reader :weapon
  attr_reader :armor
  attr_reader :accessory
  attr_reader :item
  attr_reader :job
  attr_reader :tribe
  attr_reader :medal
  attr_reader :stone

  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize
    @actor      = get_valid_actors
    @enemy      = get_valid_enemies
    @weapon     = get_valid_weapons
    @armor      = get_valid_armors
    @accessory  = get_valid_accessories
    @item       = get_valid_items
    @stone      = get_valid_stones
    @job        = get_valid_jobs
    @tribe      = get_valid_tribes
    @medal      = get_valid_medals
  end

  #--------------------------------------------------------------------------
  # ● 図鑑のアクター項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_actor
    now = comp = 0
    @actor.each do |id|
      comp += 1
      now  += 1 if actor_had?(id)
    end
    now.to_f / comp.to_f
  end

  #--------------------------------------------------------------------------
  # ● 図鑑のエネミー項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_enemy
    now = comp = 0
    @enemy.each do |id|
      comp += 1
      now  += 1 if enemy_had?(id)
    end
    now.to_f / comp.to_f
  end

  #--------------------------------------------------------------------------
  # ● 図鑑の武器項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_weapon
    now = comp = 0
    @weapon.each do |id|
      comp += 1
      now  += 1 if weapon_had?(id)
    end
    now.to_f / comp.to_f
  end

  #--------------------------------------------------------------------------
  # ● 図鑑の防具項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_armor
    now = comp = 0
    @armor.each do |id|
      comp += 1
      now  += 1 if armor_had?(id)
    end
    now.to_f / comp.to_f
  end

  #--------------------------------------------------------------------------
  # ● 図鑑のアクセサリ項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_accessory
    now = comp = 0
    @accessory.each do |id|
      comp += 1
      now  += 1 if accessory_had?(id)
    end
    now.to_f / comp.to_f
  end

  #--------------------------------------------------------------------------
  # ● 図鑑のアイテム項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_item
    now = comp = 0
    @item.each do |id|
      comp += 1
      now  += 1 if item_had?(id)
    end
    now.to_f / comp.to_f
  end

  #--------------------------------------------------------------------------
  # ● 図鑑の実績項目の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_medal
    now = comp = 0
    @medal.each do |id|
      comp += 1
      now  += 1 if has_medal?(id)
    end
    now.to_f / comp.to_f
  end

  def collect_per_stone
    @stone.count { |id| item_had?(id) }.to_f / @stone.count.to_f
  end

  #--------------------------------------------------------------------------
  # ● 図鑑の全項目合計の完成度取得
  #--------------------------------------------------------------------------
  def collect_per_all
    now = comp = 0
    # アクター
    @actor.each do |id|
      comp += 1
      now  += 1 if actor_had?(id)
    end
    # エネミー
    @enemy.each do |id|
      comp += 1
      now  += 1 if enemy_had?(id)
    end
    # ウェポン
    @weapon.each do |id|
      comp += 1
      now  += 1 if weapon_had?(id)
    end
    # アーマー
    @armor.each do |id|
      comp += 1
      now  += 1 if armor_had?(id)
    end
    # アクセサリ
    @accessory.each do |id|
      comp += 1
      now  += 1 if accessory_had?(id)
    end
    # アイテム
    @item.each do |id|
      comp += 1
      now  += 1 if item_had?(id)
    end
    comp += @stone.count
    now += @stone.count { |id| item_had?(id) }
    # 実績
    @medal.each do |id|
      comp += 1
      now  += 1 if has_medal?(id)
    end
    now.to_f / comp.to_f
  end
end

#==============================================================================
# ■ Game_Library
#----------------------------------------------------------------------------
# 図鑑に関するデータを管理します。
#==============================================================================
class Game_Library
  #--------------------------------------------------------------------------
  # ● 公開インスタンス変数
  #--------------------------------------------------------------------------
  attr_reader :actor
  attr_reader :enemy
  attr_reader :weapon
  attr_reader :armor
  attr_reader :accessory
  attr_reader :item
  attr_reader :medal

  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize
    @actor      = Flag_Library.new
    @enemy      = Flag_Library.new
    @weapon     = Flag_Library.new
    @armor      = Flag_Library.new
    @accessory  = Flag_Library.new
    @item       = Flag_Library.new
    @medal      = {}
    # 図鑑アンロックフラグ初期化
    @unlock = {
      :actor => false,
      :enemy => false,
      :weapon => false,
      :armor => false,
      :accessory => false,
      :item => false,
      :medal => false,
      :stone => false
    }
    @actor_stat = {}
    @enemy_stat = {}
    @enemy_skill = {}
    @enemy_drop  = {}
    @enemy_steal = {}
    init_party_stat
    @update = {}
    NWConst::Skill::REPLACE_ID.each_key { |key| @update[key] = true }
    @fix = { :integration_persona_data => true }
  end

  def fixd?(*keys)
    @fix ||= {}
    return true if @fix[keys]

    @fix[keys] = true
    false
  end

  def fix
    fix_integration_persona_data
  end

  def fix_integration_persona_data
    return if fixd?(:integration_persona_data)

    new_hash = {}
    @actor_stat.each do |actor_id, h|
      original_persona_id = $data_actors[actor_id].original_persona_id
      next unless actor_id != original_persona_id

      base_data = @actor_stat[original_persona_id] || {}
      new_hash[original_persona_id] = base_data.merge(h) { |_key, oldval, newval| oldval + newval }
      @actor_stat.delete(actor_id)
    end
    @actor_stat.merge!(new_hash)
  end

  #--------------------------------------------------------------------------
  # ● パーティ統計の初期化
  #--------------------------------------------------------------------------
  def init_party_stat
    @party_stat = {}
    @party_stat[:lose_event]          = {} # 敗北イベントチェック
    @party_stat[:purchase_gold]       = 0  # 購入金額
    @party_stat[:cnt_synthesize]      = 0  # 合成回数
    @party_stat[:cnt_class_change]    = 0  # 転職回数
    @party_stat[:cnt_tribe_change]    = 0  # 転種回数
    @party_stat[:cnt_battle]          = 0  # 戦闘回数
    @party_stat[:cnt_escape]          = 0  # 逃亡回数
    @party_stat[:cnt_lose]            = 0  # 敗北回数
    @party_stat[:cnt_defeat]          = 0  # 撃破総数
    @party_stat[:cnt_down]            = 0  # 倒された総数
    @party_stat[:cnt_orgasm]          = 0  # イかされた総数
    @party_stat[:cnt_friendly_orgasm] = 0  # ルガが仲間にイかされた回数
    @party_stat[:cnt_battlefuck_win]  = 0  # バトルファック勝利回数
    @party_stat[:cnt_battlefuck_lose] = 0  # バトルファック敗北回数
    @party_stat[:open_class]          = {} # 開示された職業
    @party_stat[:open_tribe]          = {} # 開示された種族
    @party_stat[:damage_record_actor] = 0  # 与えた最大ダメージ
    @party_stat[:damage_record_enemy] = 0  # 　受けた最大ダメージ
  end

  #--------------------------------------------------------------------------
  # ● ライブラリデータを基にしたリスト生成
  #--------------------------------------------------------------------------
  def make_preparation_list
    make_get_item_drop_list
    make_get_item_steal_list
  end

  #--------------------------------------------------------------------------
  # ● ドロップアイテムを所持するエネミーリストを生成
  #--------------------------------------------------------------------------
  def make_get_item_drop_list
    @get_item_drop = {}
    $data_enemies.compact.each do |enemy|
      next if enemy.name.empty? || enemy.lib_exclude?

      enemy.drop_items.each do |item|
        next if item.kind == 0

        @get_item_drop[{ :kind => item.kind, :id => item.data_id }] ||= []
        @get_item_drop[{ :kind => item.kind, :id => item.data_id }] |= [enemy.id]
      end
    end
  end

  #--------------------------------------------------------------------------
  # ● 盗めるアイテムを所持するエネミーリストを生成
  #--------------------------------------------------------------------------
  def make_get_item_steal_list
    @get_item_steal = {}
    $data_enemies.compact.each do |enemy|
      next if enemy.name.empty? || enemy.lib_exclude?

      enemy.steal_list.each_value do |steal|
        steal.each do |s|
          @get_item_steal[{ :kind => s[:kind], :id => s[:data_id] }] ||= []
          @get_item_steal[{ :kind => s[:kind], :id => s[:data_id] }] |= [enemy.id]
        end
      end
    end
  end

  #--------------------------------------------------------------------------
  # ● アクター図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_actor_unlocked?
    @unlock[:actor]
  end

  #--------------------------------------------------------------------------
  # ● エネミー図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_enemy_unlocked?
    @unlock[:enemy]
  end

  #--------------------------------------------------------------------------
  # ● ウェポン図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_weapon_unlocked?
    @unlock[:weapon]
  end

  #--------------------------------------------------------------------------
  # ● アーマー図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_armor_unlocked?
    @unlock[:armor]
  end

  #--------------------------------------------------------------------------
  # ● アクセサリ図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_accessory_unlocked?
    @unlock[:accessory]
  end

  #--------------------------------------------------------------------------
  # ● アイテム図鑑がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_item_unlocked?
    @unlock[:item]
  end

  #--------------------------------------------------------------------------
  # ● 取得実績がアンロック済みか？
  #--------------------------------------------------------------------------
  def lib_medal_unlocked?
    @unlock[:medal]
  end

  def lib_stone_unlocked?
    @unlock[:stone]
  end

  #--------------------------------------------------------------------------
  # ● アクター図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_actor
    @unlock[:actor] = true
  end

  #--------------------------------------------------------------------------
  # ● エネミー図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_enemy
    @unlock[:enemy] = true
  end

  #--------------------------------------------------------------------------
  # ● ウェポン図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_weapon
    @unlock[:weapon] = true
  end

  #--------------------------------------------------------------------------
  # ● アーマー図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_armor
    @unlock[:armor] = true
  end

  #--------------------------------------------------------------------------
  # ● アクセサリ図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_accessory
    @unlock[:accessory] = true
  end

  #--------------------------------------------------------------------------
  # ● アイテム図鑑アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_item
    @unlock[:item] = true
  end

  def unlock_lib_stone
    @unlock[:stone] = true
  end

  #--------------------------------------------------------------------------
  # ● 取得実績アンロック
  #--------------------------------------------------------------------------
  def unlock_lib_medal
    @unlock[:medal] = true
  end

  #--------------------------------------------------------------------------
  # ● アクター図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_actor
    @unlock[:actor] = false
  end

  #--------------------------------------------------------------------------
  # ● エネミー図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_enemy
    @unlock[:enemy] = false
  end

  #--------------------------------------------------------------------------
  # ● ウェポン図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_weapon
    @unlock[:weapon] = false
  end

  #--------------------------------------------------------------------------
  # ● アーマー図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_armor
    @unlock[:armor] = false
  end

  #--------------------------------------------------------------------------
  # ● アクセサリ図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_accessory
    @unlock[:accessory] = false
  end

  #--------------------------------------------------------------------------
  # ● アイテム図鑑ロック
  #--------------------------------------------------------------------------
  def lock_lib_item
    @unlock[:item] = false
  end

  #--------------------------------------------------------------------------
  # ● 取得実績ロック
  #--------------------------------------------------------------------------
  def lock_lib_medal
    @unlock[:medal] = false
  end

  def lock_lib_stone
    @unlock[:stone] = false
  end

  def actor_data(id, symbol)
    @actor_stat.dig($data_actors[id].original_persona_id, symbol) || 0
  end

  #--------------------------------------------------------------------------
  # ● アクターが撃破した回数取得
  #--------------------------------------------------------------------------
  def actor_defeat(id)
    actor_data(id, :defeat)
  end

  #--------------------------------------------------------------------------
  # ● アクターがイかせた回数取得
  #--------------------------------------------------------------------------
  def actor_carry(id)
    actor_data(id, :carry)
  end

  #--------------------------------------------------------------------------
  # ● アクターがイかされた回数取得
  #--------------------------------------------------------------------------
  def actor_orgasm(id)
    actor_data(id, :orgasm)
  end

  #--------------------------------------------------------------------------
  # ● アクターが戦闘不能になった回数取得
  #--------------------------------------------------------------------------
  def actor_down(id)
    actor_data(id, :down)
  end

  #--------------------------------------------------------------------------
  # ● アクターが戦闘参加した回数取得
  #--------------------------------------------------------------------------
  def actor_battle(id)
    actor_data(id, :battle)
  end

  #--------------------------------------------------------------------------
  # ● アクターが盗み成功した回数取得
  #--------------------------------------------------------------------------
  def actor_steal(id)
    actor_data(id, :steal)
  end

  #--------------------------------------------------------------------------
  # ● エネミーが撃破された回数取得
  #--------------------------------------------------------------------------
  def enemy_down(id)
    enemy = @enemy_stat[id] || {}
    enemy[:down] || 0
  end

  #--------------------------------------------------------------------------
  # ● エネミーが勝利した回数取得
  #--------------------------------------------------------------------------
  def enemy_victory(id)
    return 0 if $data_enemies[id] and $data_enemies[id].no_lose_skip?

    enemy = @enemy_stat[id] || {}
    enemy[:victory] || 0
  end

  #--------------------------------------------------------------------------
  # ● エネミーがイカされた回数取得
  #--------------------------------------------------------------------------
  def enemy_orgasm(id)
    enemy = @enemy_stat[id] || {}
    enemy[:orgasm] || 0
  end

  #--------------------------------------------------------------------------
  # ● エネミーがスキル使用した回数取得
  #--------------------------------------------------------------------------
  def enemy_skill_used_num(enemy_id, skill_id)
    enemy_list = @enemy_skill[enemy_id] || {}
    enemy_list[skill_id] || 0
  end

  #--------------------------------------------------------------------------
  # ● エネミーが落としたアイテムの数を取得
  #--------------------------------------------------------------------------
  def enemy_item_drop_num(enemy_id, drop)
    drop_key = { :kind => drop.kind, :data_id => drop.data_id, :denominator => drop.denominator }
    enemy_list = @enemy_drop[enemy_id] || {}
    enemy_list[drop_key] || 0
  end

  #--------------------------------------------------------------------------
  # ● エネミーから盗んだアイテムの数を取得
  #--------------------------------------------------------------------------
  def enemy_item_steal_num(enemy_id, list_id, steal)
    enemy_list = @enemy_steal[enemy_id] || {}
    steal_list = enemy_list[list_id] || {}
    steal_list[steal] || 0
  end

  #--------------------------------------------------------------------------
  # ● 敗北イベントを見た？
  #--------------------------------------------------------------------------
  def lose_event_view?(lose_event_id)
    num = @party_stat[:lose_event][lose_event_id] || 0
    0 < num
  end

  #--------------------------------------------------------------------------
  # ● 購入累計金額を取得
  #--------------------------------------------------------------------------
  def purchase_gold
    @party_stat[:purchase_gold]
  end

  #--------------------------------------------------------------------------
  # ● 合成回数を取得
  #--------------------------------------------------------------------------
  def party_synthesize
    @party_stat[:cnt_synthesize]
  end

  #--------------------------------------------------------------------------
  # ● 転職回数を取得
  #--------------------------------------------------------------------------
  def party_class_change
    @party_stat[:cnt_class_change]
  end

  #--------------------------------------------------------------------------
  # ● 転種回数を取得
  #--------------------------------------------------------------------------
  def party_tribe_change
    @party_stat[:cnt_tribe_change]
  end

  #--------------------------------------------------------------------------
  # ● パーティが戦闘した回数を取得
  #--------------------------------------------------------------------------
  def party_battle
    @party_stat[:cnt_battle]
  end

  #--------------------------------------------------------------------------
  # ● パーティが逃亡した回数を取得
  #--------------------------------------------------------------------------
  def party_escape
    @party_stat[:cnt_escape]
  end

  #--------------------------------------------------------------------------
  # ● パーティが全滅した回数を取得
  #--------------------------------------------------------------------------
  def party_lose
    @party_stat[:cnt_lose]
  end

  #--------------------------------------------------------------------------
  # ● パーティが撃破した総数を取得
  #--------------------------------------------------------------------------
  def party_defeat
    @party_stat[:cnt_defeat]
  end

  #--------------------------------------------------------------------------
  # ● パーティが倒された総数を取得
  #--------------------------------------------------------------------------
  def party_down
    @party_stat[:cnt_down]
  end

  #--------------------------------------------------------------------------
  # ● パーティがイかされた総数を取得
  #--------------------------------------------------------------------------
  def party_orgasm
    @party_stat[:cnt_orgasm]
  end

  #--------------------------------------------------------------------------
  # ● ルカが仲間にイかされた回数を取得
  #--------------------------------------------------------------------------
  def friendly_orgasm
    @party_stat[:cnt_friendly_orgasm]
  end

  #--------------------------------------------------------------------------
  # ● バトルファック勝利回数を取得
  #--------------------------------------------------------------------------
  def battlefuck_win
    @party_stat[:cnt_battlefuck_win]
  end

  #--------------------------------------------------------------------------
  # ● バトルファック敗北回数を取得
  #--------------------------------------------------------------------------
  def battlefuck_lose
    @party_stat[:cnt_battlefuck_lose]
  end

  #--------------------------------------------------------------------------
  # ● パーティの職業開示率を取得
  #--------------------------------------------------------------------------
  def party_open_class
    all = $data_library.job.size
    now = @party_stat[:open_class].size
    now.to_f / all.to_f
  end

  #--------------------------------------------------------------------------
  # ● パーティの種族開示率を取得
  #--------------------------------------------------------------------------
  def party_open_tribe
    all = $data_library.tribe.size
    now = @party_stat[:open_tribe].size
    now.to_f / all.to_f
  end

  def count_up_actor_data(id, symbol)
    id = $data_actors[id].original_persona_id
    @actor_stat[id] ||= {}
    @actor_stat[id][symbol] ||= 0
    @actor_stat[id][symbol] += 1
  end

  #--------------------------------------------------------------------------
  # ● アクターが撃破した回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_actor_defeat(id)
    count_up_actor_data(id, :defeat)
    count_up_party_defeat
  end

  #--------------------------------------------------------------------------
  # ● アクターがイかせた回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_actor_carry(id)
    count_up_actor_data(id, :carry)
  end

  #--------------------------------------------------------------------------
  # ● アクターがイかされた回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_actor_orgasm(id)
    count_up_actor_data(id, :orgasm)
    count_up_party_orgasm
  end

  #--------------------------------------------------------------------------
  # ● アクターが戦闘不能になった回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_actor_down(id)
    count_up_actor_data(id, :down)
    count_up_party_down
  end

  #--------------------------------------------------------------------------
  # ● アクターが戦闘参加した回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_actor_battle(id)
    count_up_actor_data(id, :battle)
  end

  #--------------------------------------------------------------------------
  # ● アクターが盗み成功した回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_actor_steal(id)
    count_up_actor_data(id, :steal)
  end

  #--------------------------------------------------------------------------
  # ● エネミーが撃破された回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_enemy_down(id)
    id -= 1000 if $data_enemies[id].ex_dungeon_enemy?
    @enemy_stat[id] ||= {}
    @enemy_stat[id][:down] ||= 0
    @enemy_stat[id][:down] += 1
  end

  #--------------------------------------------------------------------------
  # ● エネミーが勝利した回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_enemy_victory(id)
    id -= 1000 if $data_enemies[id].ex_dungeon_enemy?
    @enemy_stat[id] ||= {}
    @enemy_stat[id][:victory] ||= 0
    @enemy_stat[id][:victory] += 1
  end

  #--------------------------------------------------------------------------
  # ● エネミーがイかされた回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_enemy_orgasm(id)
    id -= 1000 if $data_enemies[id].ex_dungeon_enemy?
    @enemy_stat[id] ||= {}
    @enemy_stat[id][:orgasm] ||= 0
    @enemy_stat[id][:orgasm] += 1
  end

  #--------------------------------------------------------------------------
  # ● エネミーのスキル使用回数カウントアップ
  #--------------------------------------------------------------------------
  def count_up_skill_use(enemy_id, skill_id)
    @enemy_skill[enemy_id] ||= {}
    @enemy_skill[enemy_id][skill_id] ||= 0
    @enemy_skill[enemy_id][skill_id] += 1
  end

  #--------------------------------------------------------------------------
  # ● エネミーの落としたアイテムをカウントアップ
  #--------------------------------------------------------------------------
  def count_up_drop_item(enemy_id, drop)
    drop_key = { :kind => drop.kind, :data_id => drop.data_id, :denominator => drop.denominator }
    @enemy_drop[enemy_id] ||= {}
    @enemy_drop[enemy_id][drop_key] ||= 0
    @enemy_drop[enemy_id][drop_key] += 1
  end

  #--------------------------------------------------------------------------
  # ● エネミーの盗んだアイテムをカウントアップ
  #--------------------------------------------------------------------------
  def count_up_steal_item(enemy_id, list_id, steal)
    @enemy_steal[enemy_id] ||= {}
    @enemy_steal[enemy_id][list_id] ||= {}
    @enemy_steal[enemy_id][list_id][steal] ||= 0
    @enemy_steal[enemy_id][list_id][steal] += 1
  end

  #--------------------------------------------------------------------------
  # ● 敗北イベントを見た回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_lose_event(lose_event_id)
    @party_stat[:lose_event][lose_event_id] ||= 0
    @party_stat[:lose_event][lose_event_id] += 1
  end

  #--------------------------------------------------------------------------
  # ● 総購入金額を加算する
  #--------------------------------------------------------------------------
  def addition_purchase_gold(value)
    @party_stat[:purchase_gold] += value
  end

  #--------------------------------------------------------------------------
  # ● 合成回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_party_synthesize
    @party_stat[:cnt_synthesize] += 1
  end

  #--------------------------------------------------------------------------
  # ● 転職回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_party_class_change
    @party_stat[:cnt_class_change] += 1
  end

  #--------------------------------------------------------------------------
  # ● 転種回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_party_tribe_change
    @party_stat[:cnt_tribe_change] += 1
  end

  #--------------------------------------------------------------------------
  # ● パーティが戦闘した回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_party_battle
    @party_stat[:cnt_battle] += 1
  end

  #--------------------------------------------------------------------------
  # ● パーティが逃亡した回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_party_escape
    @party_stat[:cnt_escape] += 1
  end

  #--------------------------------------------------------------------------
  # ● パーティが全滅した回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_party_lose
    @party_stat[:cnt_lose] += 1
  end

  #--------------------------------------------------------------------------
  # ● パーティが撃破した総数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_party_defeat
    @party_stat[:cnt_defeat] += 1
  end

  #--------------------------------------------------------------------------
  # ● パーティが倒された総数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_party_down
    @party_stat[:cnt_down] += 1
  end

  #--------------------------------------------------------------------------
  # ● パーティがイかされた総数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_party_orgasm
    @party_stat[:cnt_orgasm] += 1
  end

  #--------------------------------------------------------------------------
  # ● ルカが仲間にイかされた回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_friendly_orgasm
    @party_stat[:cnt_friendly_orgasm] += 1
  end

  #--------------------------------------------------------------------------
  # ● バトルファック勝利回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_battlefuck_win
    @party_stat[:cnt_battlefuck_win] += 1
  end

  #--------------------------------------------------------------------------
  # ● バトルファック敗北回数をカウントアップ
  #--------------------------------------------------------------------------
  def count_up_battlefuck_lose
    @party_stat[:cnt_battlefuck_lose] += 1
  end

  #--------------------------------------------------------------------------
  # ● アクターの与えた最大ダメージ取得
  #--------------------------------------------------------------------------
  def party_damage_record_actor
    @party_stat[:damage_record_actor] || 0
  end

  #--------------------------------------------------------------------------
  # ● アクターの受けた最大ダメージ取得
  #--------------------------------------------------------------------------
  def party_damage_record_enemy
    @party_stat[:damage_record_enemy] || 0
  end

  #--------------------------------------------------------------------------
  # ● アクターの受けた最大ダメージ入力
  #--------------------------------------------------------------------------
  def set_party_damage_record_actor(damage)
    @party_stat[:damage_record_actor] = [damage, party_damage_record_actor].max
  end

  #--------------------------------------------------------------------------
  # ● アクターの受けた最大ダメージ入力
  #--------------------------------------------------------------------------
  def set_party_damage_record_enemy(damage)
    @party_stat[:damage_record_enemy] = [damage, party_damage_record_enemy].max
  end

  #--------------------------------------------------------------------------
  # ● 職業開示率をチェック
  #--------------------------------------------------------------------------
  def check_open_class(id)
    @party_stat[:open_class][id] = true
  end

  #--------------------------------------------------------------------------
  # ● 種族開示率をチェック
  #--------------------------------------------------------------------------
  def check_open_tribe(id)
    @party_stat[:open_tribe][id] = true
  end

  #--------------------------------------------------------------------------
  # ● 敵遭遇場所配列の取得
  #--------------------------------------------------------------------------
  def encounter_enemy_place(id)
    NWConst::Library::ENCOUNTER_ENEMY_PLACE[id]
  end

  #--------------------------------------------------------------------------
  # ● アイテム入手場所配列の取得
  #--------------------------------------------------------------------------
  def get_item_places(kind, id)
    case kind
    when 1
      return NWConst::Library::GET_ITEM_PLACES[id]
    when 2
      return NWConst::Library::GET_WEAPON_PLACES[id]
    when 3
      return NWConst::Library::GET_ARMOR_PLACES[id]
    end
    nil
  end

  #--------------------------------------------------------------------------
  # ● アイテムもらえる仲間配列の取得
  #--------------------------------------------------------------------------
  def get_item_actors(kind, id)
    case kind
    when 1
      return NWConst::Library::GET_ITEM_ACTORS[id]
    when 2
      return NWConst::Library::GET_WEAPON_ACTORS[id]
    when 3
      return NWConst::Library::GET_ARMOR_ACTORS[id]
    end
    nil
  end

  #--------------------------------------------------------------------------
  # ● ドロップアイテム所持エネミー配列の取得
  #--------------------------------------------------------------------------
  def get_item_drop(kind, id)
    @get_item_drop[{ :kind => kind, :id => id }]
  end

  #--------------------------------------------------------------------------
  # ● スティールアイテム所持エネミー配列の取得
  #--------------------------------------------------------------------------
  def get_item_steal(kind, id)
    @get_item_steal[{ :kind => kind, :id => id }]
  end

  #--------------------------------------------------------------------------
  # ● 場所フラグのチェック
  #--------------------------------------------------------------------------
  def place?(place)
    index = NWConst::Library::PLACE.index(place)
    index ? $game_switches[NWConst::Sw::PLACE_FLAG_BASE + index] : false
  end

  #--------------------------------------------------------------------------
  # ● 実績取得
  #--------------------------------------------------------------------------
  def gain_medal(id)
    return unless NWConst::Library::MEDAL_DATA.key?(id)
    return if NWConst::Library::NO_USE_MEDAL.include?(id)
    return if has_medal?(id)

    unlock_lib_medal
    $game_temp.gain_medal_push(id)
    @medal[id] = $game_system.realtime_s
  end

  #--------------------------------------------------------------------------
  # ● 実績取得済み？
  #--------------------------------------------------------------------------
  def has_medal?(id)
    @medal.key?(id)
  end

  #--------------------------------------------------------------------------
  # ● 実績アイコンID取得
  #--------------------------------------------------------------------------
  def medal_icon_id(id)
    NWConst::Library::MEDAL_DATA[id][:icon_id]
  end

  #--------------------------------------------------------------------------
  # ● 実績タイトル取得
  #--------------------------------------------------------------------------
  def medal_title(id)
    NWConst::Library::MEDAL_DATA[id][:title]
  end

  #--------------------------------------------------------------------------
  # ● 実績説明取得
  #--------------------------------------------------------------------------
  def medal_description(id)
    NWConst::Library::MEDAL_DATA[id][:description]
  end

  #--------------------------------------------------------------------------
  # ● 実績カテゴリー取得
  #--------------------------------------------------------------------------
  def medal_priority(id)
    NWConst::Library::MEDAL_DATA[id][:priority]
  end

  #--------------------------------------------------------------------------
  # ● 実績取得時間取得
  #--------------------------------------------------------------------------
  def medal_gain_time(id)
    has_medal?(id) ? @medal[id] : "Not Acquired"
  end

  def get_item(item)
    return if item.nil?
    return get_item(item.base_data) if item.socket_item?
    return if item.uniq_item?

    case item
    when RPG::Weapon
      @weapon.set_had(item.id)
      unlock_lib_weapon
    when RPG::Armor
      if item.is_accessory?
        @accessory.set_had(item.id)
        unlock_lib_accessory
      else
        @armor.set_had(item.id)
        unlock_lib_armor
      end
    when RPG::Item
      @item.set_had(item.id)
      if item.enchant_stone?
        unlock_lib_stone
      else
        unlock_lib_item
      end
    end
  end

  def change_enemy_skill_used_id(args)
    tenemy_skill = Marshal.load(Marshal.dump(@enemy_skill))
    args.each do |before_id, after_id|
      @enemy_skill.each do |enemy_id, enemy_list|
        next unless enemy_list.key?(before_id)

        tenemy_skill[enemy_id][after_id] = enemy_list[before_id]
        tenemy_skill[enemy_id].delete(before_id)
      end
    end
    @enemy_skill = tenemy_skill
  end

  def refresh_skill_update
    @update ||= {}
    NWConst::Skill::REPLACE_ID.each_key do |key|
      next if @update.key?(key)

      r = NWConst::Skill::REPLACE_ID.fetch(key, nil)
      next unless r

      @update[key] = true
      change_enemy_skill_used_id(r)
    end
  end

  def refresh_open_stone
    return unless @unlock[:stone].nil?

    @unlock[:stone] = $data_library.collect_per_stone > 0
  end
end
